/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.ChartPersonNames;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class ChartPersonName
extends Chart {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    static final CLDRFile ENGLISH = CLDR_CONFIG.getEnglish();
    static final String DIR = ChartPersonNames.DIR;
    static final Map<PersonNameFormatter.SampleType, SimpleNameObject> ENGLISH_NAMES = PersonNameFormatter.loadSampleNames(ENGLISH);
    private final String locale;

    public ChartPersonName(String locale) {
        this.locale = locale;
    }

    @Override
    public String getDirectory() {
        return DIR;
    }

    @Override
    public String getTitle() {
        return ENGLISH.nameGetter().getNameFromIdentifier(this.locale) + ": Person Names";
    }

    @Override
    public String getExplanation() {
        return "<p>This chart shows the different ways that the sample native names and sample foreign names would be formatted.</p>";
    }

    @Override
    public String getFileName() {
        return this.locale;
    }

    @Override
    public void writeContents(Writer pw, Factory factory) throws IOException {
        CLDRFile cldrFile = factory.make(this.locale, true);
        Map<PersonNameFormatter.SampleType, SimpleNameObject> names = PersonNameFormatter.loadSampleNames(cldrFile);
        if (names.isEmpty()) {
            pw.write("<p>No sample names to display.</p>");
            return;
        }
        pw.write("<div class='ReportChart'>\n");
        PersonNameFormatter formatter = new PersonNameFormatter(cldrFile);
        for (Source source : Source.values()) {
            for (Filter filter : Filter.values()) {
                TablePrinter tablePrinter = new TablePrinter().addColumn("Order", "class='source'", null, "class='source'", true).addColumn("Length", "class='source'", null, "class='source'", true).addColumn("Usage", "class='source'", null, "class='source'", true).addColumn("Formality", "class='source'", null, "class='source'", true);
                for (PersonNameFormatter.SampleType sampleType : PersonNameFormatter.SampleType.ALL) {
                    if (sampleType.isNative() != (source == Source.NativeSamples)) continue;
                    tablePrinter.addColumn(sampleType.toString(), "class='target'", null, "class='target'", true);
                }
                tablePrinter.addColumn("view", "class='source'", null, "class='source'", true);
                Iterator iterator = PersonNameFormatter.FormatParameters.allCldr().iterator();
                while (iterator.hasNext()) {
                    PersonNameFormatter.FormatParameters parameters;
                    if (filter == Filter.Monogram != ((parameters = (PersonNameFormatter.FormatParameters)iterator.next()).getUsage() == PersonNameFormatter.Usage.monogram) || filter == Filter.Sorting != (parameters.getOrder() == PersonNameFormatter.Order.sorting)) continue;
                    tablePrinter.addRow().addCell((Comparable)((Object)parameters.getOrder())).addCell((Comparable)((Object)parameters.getLength())).addCell((Comparable)((Object)parameters.getUsage())).addCell((Comparable)((Object)parameters.getFormality()));
                    for (PersonNameFormatter.SampleType sampleType : PersonNameFormatter.SampleType.ALL) {
                        String value;
                        if (sampleType.isNative() != (source == Source.NativeSamples)) continue;
                        SimpleNameObject nameObject = names.get((Object)sampleType);
                        String string = value = nameObject == null ? "" : formatter.format(nameObject, parameters);
                        if (parameters.getUsage() == PersonNameFormatter.Usage.monogram && (value.contains("..") || value.contains(". .") || value.endsWith(".") || value.startsWith("."))) {
                            System.err.println("Error: " + this.locale + "\t" + String.valueOf(parameters) + "\t" + value + "\t" + String.valueOf(nameObject.getAvailableFields()));
                        }
                        tablePrinter.addCell((Comparable)((Object)(value.isBlank() ? "<i>missing</i>" : value)));
                    }
                    String path = "//ldml/personNames/personName[@order=\"" + String.valueOf((Object)parameters.getOrder()) + "\"][@length=\"" + String.valueOf((Object)parameters.getLength()) + "\"][@usage=\"" + String.valueOf((Object)parameters.getUsage()) + "\"][@formality=\"" + String.valueOf((Object)parameters.getFormality()) + "\"]/namePattern";
                    tablePrinter.addCell((Comparable)((Object)this.getFixLinkFromPath(cldrFile, path)));
                    tablePrinter.finishRow();
                }
                pw.write("\n<h2>" + String.valueOf((Object)source) + ": " + String.valueOf((Object)filter) + "</h2>\n");
                pw.write(tablePrinter.toTable());
                tablePrinter.clearRows();
            }
        }
        pw.write("</div> <!-- ReportChart -->\n");
    }

    static enum Source {
        NativeSamples,
        ForeignSamples;

    }

    static enum Filter {
        Main,
        Sorting,
        Monogram;

    }
}

