/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnicodeSets;

public class ListRedundantUnicodeSets {
    private static UnicodeSet ROOT_COLLATION_EXEMPLARS = null;
    static final Normalizer2 nfkd = Normalizer2.getNFKDInstance();
    static final Set<String> CAN_BE_COMPOSED;
    static final UnicodeSet NUKTA;
    static final Multimap<String, String> TRANSLIT_CLUSTERS;

    public static void main(String[] args) {
        System.out.println("LocaleID\tTarget Level\tExemplarType\tNo. Original\tNo. Remaining\tNot Redundant (KEEP)\tRedundant Exceptions (KEEP)\tIndexEx & Redundant\tCollation & Redundant\tOther Redundant\tNo. Collation clusters not in exemplars");
        Factory cldrFactory = CLDRConfig.getInstance().getCldrFactory();
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        StandardCodes sdc = StandardCodes.make();
        for (String localeID : cldrFactory.getAvailable()) {
            Level localeCoverageLevel = sdc.getLocaleCoverageLevel(Organization.cldr, localeID);
            if (localeCoverageLevel == Level.UNDETERMINED) continue;
            CLDRFile cldrFile = cldrFactory.make(localeID, false);
            for (CLDRFile.ExemplarType exemplarType : Arrays.asList(CLDRFile.ExemplarType.main)) {
                UnicodeSet exemplarSet = cldrFile.getExemplarSet(exemplarType, CLDRFile.WinningChoice.WINNING);
                if (exemplarSet.isEmpty()) continue;
                Set<String> redundants = UnicodeSets.getRedundantStrings(exemplarSet);
                TreeSet<String> remaining = new TreeSet<String>(exemplarSet.strings());
                remaining.removeAll(redundants);
                TreeSet<String> forTranslit = new TreeSet<String>();
                for (String r : redundants) {
                    if (!ListRedundantUnicodeSets.isForTranslit(localeID, r)) continue;
                    forTranslit.add(r);
                }
                redundants.removeAll(forTranslit);
                TreeSet<String> indexSet = new TreeSet<String>();
                UnicodeSet indexSetRaw = cldrFile.getExemplarSet(CLDRFile.ExemplarType.index, CLDRFile.WinningChoice.WINNING);
                if (!indexSetRaw.isEmpty()) {
                    ULocale ulocale = new ULocale(localeID);
                    for (String s2 : indexSetRaw) {
                        String lowerCase = UCharacter.toLowerCase(ulocale, s2);
                        if (UnicodeSet.getSingleCodePoint(lowerCase) != Integer.MAX_VALUE) continue;
                        indexSet.add(lowerCase);
                    }
                    if (!indexSet.isEmpty()) {
                        redundants.removeAll(indexSet);
                        indexSet.removeAll(redundants);
                    }
                }
                Set colExemplars = ListRedundantUnicodeSets.getCollationExemplars(localeID).addAllTo(new TreeSet());
                Set colAndEx = Collections.emptySet();
                if (!colExemplars.isEmpty()) {
                    colAndEx = new TreeSet(colExemplars);
                    colAndEx.retainAll(redundants);
                    redundants.removeAll(colAndEx);
                    colExemplars.removeAll(redundants);
                    colExemplars.removeAll(remaining);
                    colExemplars.removeAll(forTranslit);
                }
                System.out.println(localeID + "\t" + String.valueOf((Object)localeCoverageLevel) + "\t" + String.valueOf((Object)exemplarType) + "\t" + exemplarSet.strings().size() + "\t" + (remaining.size() + forTranslit.size()) + "\t" + String.valueOf(remaining) + "\t" + String.valueOf(forTranslit) + "\t" + String.valueOf(indexSet) + "\t" + String.valueOf(colAndEx) + "\t" + String.valueOf(redundants) + "\t" + colExemplars.size());
            }
        }
    }

    private static UnicodeSet getCollationExemplars(String localeID) {
        if (ROOT_COLLATION_EXEMPLARS == null) {
            ROOT_COLLATION_EXEMPLARS = ListRedundantUnicodeSets.getCollationExemplars2("root");
        }
        UnicodeSet result = ListRedundantUnicodeSets.getCollationExemplars2(localeID).removeAll(ROOT_COLLATION_EXEMPLARS);
        return result;
    }

    private static UnicodeSet getCollationExemplars2(String localeID) {
        try {
            Locale locale = new Locale(localeID);
            ICUServiceBuilder builder = ICUServiceBuilder.forLocale(CLDRLocale.getInstance(localeID));
            RuleBasedCollator col = builder.getRuleBasedCollator();
            UnicodeSet contractions = new UnicodeSet();
            UnicodeSet expansions = new UnicodeSet();
            col.getContractionsAndExpansions(contractions, expansions, true);
            UnicodeSet result = new UnicodeSet();
            for (String s2 : contractions) {
                result.add(s2.toLowerCase(locale));
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isForTranslit(String locale, String s2) {
        boolean result = CAN_BE_COMPOSED.contains(nfkd.normalize(s2));
        return result && (NUKTA.containsSome(s2) || TRANSLIT_CLUSTERS.containsEntry(locale, s2));
    }

    static {
        TreeSet<String> _toComposed = new TreeSet<String>();
        UnicodeSet options = new UnicodeSet("[[:nfkcqc=n:]-[:dt=final:]-[:dt=medial:]-[:dt=initial:]-[:dt=isolated:]]");
        StringBuffer b = new StringBuffer();
        for (UnicodeSet.EntryRange range : options.ranges()) {
            for (int cp = range.codepoint; cp <= range.codepointEnd; ++cp) {
                b.setLength(0);
                String result = nfkd.normalize(b.appendCodePoint(cp));
                if (UnicodeSet.getSingleCodePoint(result) != Integer.MAX_VALUE) continue;
                _toComposed.add(result);
            }
        }
        CAN_BE_COMPOSED = ImmutableSet.copyOf(_toComposed);
        NUKTA = new UnicodeSet("[:Indic_Syllabic_Category=nukta:]").freeze();
        TRANSLIT_CLUSTERS = ImmutableMultimap.builder().putAll("bs", "d\u017e", "lj", "nj").putAll("hr", (String[])new String[]{"d\u017e", "lj", "nj"}).putAll("sr_Latn", (String[])new String[]{"d\u017e", "lj", "nj"}).build();
    }
}

