/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.ListFormatter;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.TempPrintWriter;

public class DTD2Markdown {
    final Path dir = CLDRPaths.getDtd2MdDirectory();
    static final ListFormatter lf = ListFormatter.getInstance(Locale.ENGLISH, ListFormatter.Type.AND, ListFormatter.Width.NARROW);

    public DTD2Markdown() {
        this.dir.toFile().mkdirs();
    }

    public void write(DtdData data, DtdType type) {
        String name = type.toString();
        File mdFile = this.dir.resolve("elements_" + name + ".md").toFile();
        DTD2Markdown.writeMarkdown(mdFile, data, type);
    }

    public static void writeMarkdown(File mdFile, DtdData data, DtdType type) {
        try (TempPrintWriter out = TempPrintWriter.openUTF8Writer(mdFile.getAbsolutePath());){
            out.println("# DTD data: " + String.valueOf((Object)type));
            out.println();
            for (DtdData.Element e : data.getElements()) {
                out.println(String.format("### <a name=\"Element_%s\" href=\"#Element_%s\">Element: %s</a>", e.getName(), e.getName(), e.getName()));
                out.println();
                out.println("> <small>");
                out.println(">");
                out.println("> Parents: " + DTD2Markdown.getParents(data, e));
                out.println(">");
                out.println("> Children: " + DTD2Markdown.getChildren(e));
                out.println(">");
                out.println("> Occurrence: " + DTD2Markdown.getOccurrence(e));
                out.println("> </small>");
                out.println();
                Set<DtdData.Attribute> attrs = e.getAttributes().keySet();
                if (!attrs.isEmpty()) {
                    TreeSet<DtdData.Attribute> ts = new TreeSet<DtdData.Attribute>(new Comparator<DtdData.Attribute>(){

                        @Override
                        public int compare(DtdData.Attribute o1, DtdData.Attribute o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    ts.addAll(attrs);
                    for (DtdData.Attribute a : ts) {
                        out.println("_Attribute:_ " + DTD2Markdown.escapeStr(a.getName()) + DTD2Markdown.getAttr(a));
                        out.println();
                    }
                }
                out.println("* * *");
                out.println();
            }
            System.err.println("Wrote MD : " + mdFile.getPath());
        }
    }

    private static String getAttr(DtdData.Attribute a) {
        if (a.mode == DtdData.Mode.FIXED) {
            return " (fixed by DTD)";
        }
        if (a.mode == DtdData.Mode.OPTIONAL) {
            return "";
        }
        if (a.mode == DtdData.Mode.REQUIRED) {
            return " (required)";
        }
        return "";
    }

    private static String getOccurrence(DtdData.Element e) {
        return "?, ?";
    }

    private static String getChildren(DtdData.Element e) {
        return DTD2Markdown.setToString(e.getChildren().keySet().stream());
    }

    private static String setToString(Stream<DtdData.Element> children) {
        String ret = lf.format(children.map(DtdData.Element::getName).sorted().map(DTD2Markdown::linkifyElementStr).collect(Collectors.toList()));
        if (ret.isEmpty()) {
            return "_none_";
        }
        return ret;
    }

    private static String getParents(DtdData data, DtdData.Element e) {
        return DTD2Markdown.setToString(data.getElements().stream().filter(p -> p.getChildren().containsKey(e)));
    }

    public static String escapeStr(String t2) {
        return "`" + t2 + "`";
    }

    public static String linkifyElementStr(String t2) {
        if (t2.equals("special")) {
            return "[_special_](tr35.md#special)";
        }
        return "[" + t2 + "](#Element_" + t2 + ")";
    }
}

