/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.BigIntegerMath;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.UnlocalizedNumberFormatter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.Output;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 1L;
    private static final Pattern INT_POWER_10 = Pattern.compile("10*");
    public final BigInteger numerator;
    public final BigInteger denominator;
    static final BigInteger BI_TWO = BigInteger.valueOf(2L);
    static final BigInteger BI_FIVE = BigInteger.valueOf(5L);
    static final BigInteger BI_MINUS_ONE = BigInteger.valueOf(-1L);
    static final BigInteger BI_TEN = BigInteger.valueOf(10L);
    static final BigDecimal BD_TWO = BigDecimal.valueOf(2L);
    static final BigDecimal BD_FIVE = BigDecimal.valueOf(5L);
    public static final Rational ZERO = new Rational(BigInteger.ZERO, BigInteger.ONE);
    public static final Rational ONE = new Rational(BigInteger.ONE, BigInteger.ONE);
    public static final Rational NaN = new Rational(BigInteger.ZERO, BigInteger.ZERO);
    public static final Rational INFINITY = new Rational(BigInteger.ONE, BigInteger.ZERO);
    public static final Rational NEGATIVE_ONE = ONE.negate();
    public static final Rational NEGATIVE_INFINITY = INFINITY.negate();
    public static final Rational TWO = new Rational(BI_TWO, BigInteger.ONE);
    public static final Rational TEN = new Rational(BI_TEN, BigInteger.ONE);
    public static final Rational TENTH = TEN.reciprocal();
    public static final char REPTEND_MARKER = '\u02d9';
    public static final String APPROX = "~";
    private static final BigInteger NUM_OR_DEN_LIMIT = BigInteger.valueOf(10000000L);
    private static final BigInteger NUM_TIMES_DEN_LIMIT = BigInteger.valueOf(10000000L);
    private static final BigInteger BIG_HIGH = BigInteger.valueOf(10000000L);
    private static final double DOUBLE_HIGH = 1.0E7;
    private static final double DOUBLE_LOW = 0.001;
    static final String THIN_SPACE = "\u2009";
    static final String DIVIDER = "/";
    static final String HUMAN_EXPONENT = "\u00d710\u02c6";
    private static final LocalizedNumberFormatter formatGroup = ((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.unlimited())).locale(Locale.ENGLISH);
    private static final LocalizedNumberFormatter formatNoGroup = ((UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.unlimited())).grouping(NumberFormatter.GroupingStrategy.OFF)).locale(Locale.ENGLISH);
    private static final LocalizedNumberFormatter formatSigDig5 = ((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.maxSignificantDigits(5))).locale(Locale.ENGLISH);
    private static final LocalizedNumberFormatter formatSciSigDig5 = ((UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)NumberFormatter.with().precision(Precision.maxSignificantDigits(5))).notation(Notation.engineering())).locale(Locale.ENGLISH);
    public static final Rational EPSILON = Rational.of(1L, 1000000L);

    public static Rational of(long numerator, long denominator) {
        return Rational.of(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational of(long numerator) {
        return Rational.of(BigInteger.valueOf(numerator), BigInteger.ONE);
    }

    public static Rational of(BigInteger numerator, BigInteger denominator) {
        int dComparison = denominator.compareTo(BigInteger.ZERO);
        if (dComparison == 0) {
            int nComparison = numerator.compareTo(BigInteger.ZERO);
            return nComparison < 0 ? NEGATIVE_INFINITY : (nComparison > 0 ? INFINITY : NaN);
        }
        BigInteger gcd = numerator.gcd(denominator);
        if (gcd.compareTo(BigInteger.ONE) > 0) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        if (dComparison < 0) {
            return new Rational(numerator, denominator);
        }
        return new Rational(numerator.negate(), denominator.negate());
    }

    public static Rational of(BigInteger numerator) {
        return new Rational(numerator, BigInteger.ONE);
    }

    public static Rational of(String simple) {
        return RationalParser.BASIC.parse(simple);
    }

    private Rational(BigInteger numerator, BigInteger denominator) {
        BigInteger gcd;
        if (denominator.compareTo(BigInteger.ZERO) < 0) {
            numerator = numerator.negate();
            denominator = denominator.negate();
        }
        if ((gcd = numerator.gcd(denominator)).compareTo(BigInteger.ONE) > 0) {
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Rational add(Rational other) {
        BigInteger newNumerator = this.numerator.multiply(other.denominator).add(other.numerator.multiply(this.denominator));
        BigInteger newDenominator = this.denominator.multiply(other.denominator);
        return Rational.of(newNumerator, newDenominator);
    }

    public Rational subtract(Rational other) {
        BigInteger newNumerator = this.numerator.multiply(other.denominator).subtract(other.numerator.multiply(this.denominator));
        BigInteger newDenominator = this.denominator.multiply(other.denominator);
        return Rational.of(newNumerator, newDenominator);
    }

    public Rational multiply(Rational other) {
        BigInteger newNumerator = this.numerator.multiply(other.numerator);
        BigInteger newDenominator = this.denominator.multiply(other.denominator);
        return Rational.of(newNumerator, newDenominator);
    }

    public Rational divide(Rational other) {
        BigInteger newNumerator = this.numerator.multiply(other.denominator);
        BigInteger newDenominator = this.denominator.multiply(other.numerator);
        return Rational.of(newNumerator, newDenominator);
    }

    public Rational pow(int i) {
        return Rational.of(this.numerator.pow(i), this.denominator.pow(i));
    }

    public static Rational pow10(int i) {
        return i > 0 ? TEN.pow(i) : TENTH.pow(-i);
    }

    public Rational reciprocal() {
        return Rational.of(this.denominator, this.numerator);
    }

    public Rational negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    public BigDecimal toBigDecimal(MathContext mathContext) {
        try {
            return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), mathContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Wrong math context for divide: " + String.valueOf(this) + ", " + String.valueOf(mathContext));
        }
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(MathContext.DECIMAL128);
    }

    @Override
    public double doubleValue() {
        if (this.denominator.equals(BigInteger.ZERO) && this.numerator.equals(BigInteger.ZERO)) {
            return Double.NaN;
        }
        return this.toBigDecimal(MathContext.DECIMAL64).doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.denominator.equals(BigInteger.ZERO) && this.numerator.equals(BigInteger.ZERO)) {
            return Float.NaN;
        }
        return this.toBigDecimal(MathContext.DECIMAL32).floatValue();
    }

    public static Rational of(BigDecimal bigDecimal) {
        int scale = bigDecimal.scale();
        BigInteger unscaled = bigDecimal.unscaledValue();
        if (scale == 0) {
            return new Rational(unscaled, BigInteger.ONE);
        }
        if (scale >= 0) {
            return Rational.of(unscaled, BigDecimal.ONE.movePointRight(scale).toBigInteger());
        }
        return new Rational(unscaled.multiply(BigDecimal.ONE.movePointLeft(scale).toBigInteger()), BigInteger.ONE);
    }

    public static Rational of(double doubleValue) {
        return Rational.of(new BigDecimal(doubleValue));
    }

    public String toString() {
        return this.toString(FormatStyle.plain);
    }

    public String toString(FormatStyle style) {
        Object result;
        boolean denIsOne = this.denominator.equals(BigInteger.ONE);
        BigInteger absNumerator = this.numerator.abs();
        block0 : switch (style) {
            case plain: {
                result = String.valueOf(this.numerator) + (String)(denIsOne ? "" : DIVIDER + String.valueOf(this.denominator));
                break;
            }
            case approx: {
                if (denIsOne) {
                    if (absNumerator.compareTo(BIG_HIGH) < 0) {
                        result = formatGroup.format(this.numerator).toString();
                        break;
                    }
                    result = this.replaceE(formatSciSigDig5.format(this.numerator).toString());
                    break;
                }
                int log10num = BigIntegerMath.log10(absNumerator, RoundingMode.UP);
                int log10den = BigIntegerMath.log10(this.denominator, RoundingMode.UP);
                if (log10num <= 1 && log10den <= 4 || log10num <= 4 && log10den <= 1) {
                    result = String.valueOf(formatGroup.format(this.numerator)) + DIVIDER + String.valueOf(formatNoGroup.format(this.denominator));
                    break;
                }
                double doubleValue = this.numerator.doubleValue() / this.denominator.doubleValue();
                double absDoubleValue = Math.abs(doubleValue);
                if (0.001 < absDoubleValue && absDoubleValue < 1.0E7) {
                    result = formatSigDig5.format(doubleValue).toString();
                    break;
                }
                result = formatSciSigDig5.format(doubleValue).toString();
                break;
            }
            default: {
                Output<BigDecimal> newNumerator = new Output<BigDecimal>(new BigDecimal(this.numerator));
                BigInteger newDenominator = Rational.minimalDenominator(newNumerator, this.denominator);
                String numStr = formatGroup.format((Number)newNumerator.value).toString();
                String denStr = formatNoGroup.format(newDenominator).toString();
                denIsOne = newDenominator.equals(BigInteger.ONE);
                int limit = 1000;
                switch (style) {
                    case repeating: {
                        limit = 30;
                    }
                    case repeatingAll: {
                        result = this.toRepeating(limit);
                        if (result != null) break block0;
                    }
                    case formatted: {
                        result = denIsOne ? numStr : numStr + DIVIDER + denStr;
                        break block0;
                    }
                    case html: {
                        return denIsOne ? numStr : "<sup>" + numStr + "</sup>/<sub>" + denStr + "<sub>";
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        Rational roundtrip = Rational.of((String)result);
        return this.replaceE((String)(roundtrip.equals(this) ? result : APPROX + (String)result));
    }

    private String replaceE(String format2) {
        return format2.replace("E", HUMAN_EXPONENT);
    }

    @Override
    public int compareTo(Rational other) {
        return this.numerator.multiply(other.denominator).compareTo(other.numerator.multiply(this.denominator));
    }

    public boolean equals(Object that) {
        return this.equals((Rational)that);
    }

    public boolean equals(Rational that) {
        return this.numerator.equals(that.numerator) && this.denominator.equals(that.denominator);
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public Rational abs() {
        return this.numerator.signum() >= 0 ? this : this.negate();
    }

    public static BigInteger minimalDenominator(Output<BigDecimal> outNumerator, BigInteger denominator) {
        if (denominator.equals(BigInteger.ONE) || denominator.equals(BigInteger.ZERO)) {
            return denominator;
        }
        BigInteger newDenominator = denominator;
        while (newDenominator.mod(BI_TWO).equals(BigInteger.ZERO)) {
            newDenominator = newDenominator.divide(BI_TWO);
            outNumerator.value = ((BigDecimal)outNumerator.value).divide(BD_TWO);
        }
        BigInteger outDenominator = newDenominator;
        while (newDenominator.mod(BI_FIVE).equals(BigInteger.ZERO)) {
            newDenominator = newDenominator.divide(BI_FIVE);
            outNumerator.value = ((BigDecimal)outNumerator.value).divide(BD_FIVE);
        }
        return newDenominator;
    }

    public BigInteger floor() {
        return this.numerator.divide(this.denominator);
    }

    public Rational symmetricDiff(Rational b) {
        return this.equals(b) ? ZERO : this.subtract(b).abs().multiply(TWO).divide(this.add(b));
    }

    private String toRepeating(int stringLimit) {
        int pToq;
        BigInteger p = this.numerator;
        BigInteger q = this.denominator;
        StringBuilder s2 = new StringBuilder();
        int pTo0 = p.compareTo(BigInteger.ZERO);
        if (q.compareTo(BigInteger.ZERO) == 0) {
            return pTo0 == 0 ? "NaN" : (pTo0 > 0 ? "INF" : "-INF");
        }
        if (pTo0 == 0) {
            return "0";
        }
        if (pTo0 < 0) {
            p = p.negate();
            s2.append('-');
        }
        if ((pToq = p.compareTo(q)) == 0) {
            s2.append('1');
            return s2.toString();
        }
        if (pToq > 0) {
            BigInteger intPart = p.divide(q);
            s2.append(formatNoGroup.format(intPart));
            p = p.remainder(q);
            if (p.compareTo(BigInteger.ZERO) == 0) {
                return s2.toString();
            }
        } else {
            s2.append('0');
        }
        s2.append(".");
        int pos = -1;
        HashMap<BigInteger, Integer> occurs = new HashMap<BigInteger, Integer>();
        while (!occurs.containsKey(p)) {
            occurs.put(p, pos);
            BigInteger p10 = p.multiply(BigInteger.TEN);
            BigInteger z = p10.divide(q);
            p = p10.subtract(z.multiply(q));
            s2 = s2.append((char)(48 + z.intValue()));
            if (p.equals(BigInteger.ZERO)) {
                return s2.toString();
            }
            if (s2.length() > stringLimit) {
                return null;
            }
            --pos;
        }
        int L = (Integer)occurs.get(p) - pos;
        s2.insert(s2.length() - L, '\u02d9');
        return s2.toString();
    }

    public boolean isPowerOfTen() {
        Output<BigDecimal> newNumerator = new Output<BigDecimal>(new BigDecimal(this.numerator));
        BigInteger newDenominator = Rational.minimalDenominator(newNumerator, this.denominator);
        if (!newDenominator.equals(BigInteger.ONE)) {
            return false;
        }
        String str = ((BigDecimal)newNumerator.value).unscaledValue().toString();
        return INT_POWER_10.matcher(str).matches();
    }

    public String getIntPowerOfTen() {
        int sign;
        BigInteger value;
        if (this.numerator.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Prefix label must be positive: " + String.valueOf(this));
        }
        if (!this.numerator.equals(BigInteger.ONE) && !this.denominator.equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("Prefix label must be power of 10: " + String.valueOf(this));
        }
        if (this.numerator.equals(BigInteger.ONE)) {
            value = this.denominator;
            sign = -1;
        } else {
            value = this.numerator;
            sign = 1;
        }
        String str = value.toString();
        if (!INT_POWER_10.matcher(str).matches()) {
            throw new IllegalArgumentException("Prefix label must be power of 10: " + String.valueOf(this));
        }
        int result = str.length() - 1;
        return String.valueOf(result * sign);
    }

    public boolean approximatelyEquals(Rational b, Rational epsilon) {
        return this.symmetricDiff(b).compareTo(epsilon) < 0;
    }

    public boolean approximatelyEquals(Rational b) {
        return this.approximatelyEquals(b, EPSILON);
    }

    public boolean approximatelyEquals(Number b) {
        return this.approximatelyEquals(Rational.of(b.doubleValue()), EPSILON);
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    public static class ContinuedFraction {
        public final List<BigInteger> sequence;

        public ContinuedFraction(Rational source) {
            ArrayList<BigInteger> _sequence = new ArrayList<BigInteger>();
            while (true) {
                BigInteger floor;
                if ((floor = source.floor()).compareTo(BigInteger.ZERO) < 0) {
                    floor = floor.subtract(BigInteger.ONE);
                }
                Rational remainder = source.subtract(Rational.of(floor, BigInteger.ONE));
                _sequence.add(floor);
                if (remainder.equals(ZERO)) break;
                source = remainder.reciprocal();
            }
            this.sequence = ImmutableList.copyOf(_sequence);
        }

        public ContinuedFraction(long ... items) {
            ArrayList<BigInteger> _sequence = new ArrayList<BigInteger>();
            int count = 0;
            for (long item : items) {
                if (count != 0 && item < 0L) {
                    throw new IllegalArgumentException("Only first item can be negative");
                }
                _sequence.add(BigInteger.valueOf(item));
                ++count;
            }
            this.sequence = ImmutableList.copyOf(_sequence);
        }

        public Rational toRational(List<Rational> intermediates) {
            if (intermediates != null) {
                intermediates.clear();
            }
            BigInteger h0 = BigInteger.ZERO;
            BigInteger h1 = BigInteger.ONE;
            BigInteger k0 = BigInteger.ONE;
            BigInteger k1 = BigInteger.ZERO;
            for (BigInteger item : this.sequence) {
                BigInteger h2 = item.multiply(h1).add(h0);
                BigInteger k2 = item.multiply(k1).add(k0);
                if (intermediates != null) {
                    intermediates.add(Rational.of(h2, k2));
                }
                h0 = h1;
                h1 = h2;
                k0 = k1;
                k1 = k2;
            }
            if (intermediates != null) {
                Rational last = intermediates.get(intermediates.size() - 1);
                intermediates.remove(intermediates.size() - 1);
                return last;
            }
            return Rational.of(h1, k1);
        }

        public String toString() {
            return this.sequence.toString();
        }

        public boolean equals(Object obj) {
            return this.sequence.equals(((ContinuedFraction)obj).sequence);
        }

        public int hashCode() {
            return this.sequence.hashCode();
        }
    }

    public static class MutableLong {
        public long value;

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FormatStyle {
        plain,
        approx,
        repeating,
        repeatingAll,
        formatted,
        html;

    }

    public static class RationalParser
    implements Freezable<RationalParser> {
        public static final RationalParser BASIC = new RationalParser().freeze();
        private static final Splitter slashSplitter = Splitter.on('/').trimResults();
        private static final Splitter starSplitter = Splitter.on('*').trimResults();
        private Map<String, Rational> constants;
        private Map<String, String> constantStatus;
        static final UnicodeSet ALLOWED_CHARS = new UnicodeSet("[-A-Za-z0-9_]").add(729).freeze();
        boolean frozen = false;

        public RationalParser() {
            this.constants = new LinkedHashMap<String, Rational>();
            this.constantStatus = new LinkedHashMap<String, String>();
        }

        public RationalParser(Map<String, Rational> constants2, Map<String, String> constantStatus2) {
            this.frozen = false;
            this.constants = new LinkedHashMap<String, Rational>(constants2);
            this.constantStatus = new LinkedHashMap<String, String>(constantStatus2);
        }

        public RationalParser addConstant(String id, String value, String status) {
            Rational parsed = this.parse(value);
            if (this.constants.put(id, parsed) != null) {
                throw new IllegalArgumentException("Can't reset constant " + id + " = " + value);
            }
            if (status != null) {
                this.constantStatus.put(id, status);
            }
            return this;
        }

        public Rational parse(String input) {
            switch (input) {
                case "NaN": {
                    return NaN;
                }
                case "INF": {
                    return INFINITY;
                }
                case "-INF": {
                    return NEGATIVE_INFINITY;
                }
            }
            if (input.startsWith(Rational.APPROX)) {
                input = input.substring(1);
            }
            input = input.replace(",", "");
            List<String> comps = slashSplitter.splitToList(input);
            try {
                switch (comps.size()) {
                    case 1: {
                        return this.process(comps.get(0));
                    }
                    case 2: {
                        return this.process(comps.get(0)).divide(this.process(comps.get(1)));
                    }
                }
                throw new IllegalArgumentException("too many slashes in " + input);
            }
            catch (Exception e) {
                throw new ICUException("bad input: " + input, e);
            }
        }

        private Rational process(String string) {
            Rational result = null;
            string = string.replace(Rational.HUMAN_EXPONENT, "E");
            for (String comp : starSplitter.split(string)) {
                Rational ratComp = this.process2(comp);
                result = result == null ? ratComp : result.multiply(ratComp);
            }
            return result;
        }

        private Rational process2(String input) {
            char firstChar = ((String)input).charAt(0);
            if (firstChar == '-' || firstChar >= '0' && firstChar <= '9') {
                int pos = ((String)input).indexOf(729);
                if (pos < 0) {
                    return Rational.of(new BigDecimal((String)input));
                }
                String reptend = ((String)input).substring(pos + 1);
                int rlen = reptend.length();
                input = ((String)input).substring(0, pos) + reptend;
                BigDecimal rf = new BigDecimal((String)input);
                BigDecimal rfPow = new BigDecimal((String)input + reptend).scaleByPowerOfTen(rlen);
                BigDecimal num = rfPow.subtract(rf);
                Rational result = Rational.of(num);
                Rational den = Rational.of(BigDecimal.ONE.scaleByPowerOfTen(rlen).subtract(BigDecimal.ONE));
                return result.divide(den);
            }
            if (!ALLOWED_CHARS.containsAll((String)input)) {
                throw new IllegalArgumentException("Bad characters in: " + (String)input);
            }
            Rational result = this.constants.get(input);
            if (result == null) {
                throw new IllegalArgumentException("Constant not defined: " + (String)input);
            }
            return result;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public RationalParser freeze() {
            if (!this.frozen) {
                this.frozen = true;
                this.constants = ImmutableMap.copyOf(this.constants);
                this.constantStatus = ImmutableMap.copyOf(this.constantStatus);
            }
            return this;
        }

        @Override
        public RationalParser cloneAsThawed() {
            return new RationalParser(this.constants, this.constantStatus);
        }

        public Map<String, Rational> getConstants() {
            return this.constants;
        }
    }
}

